#!/bin/sh

ORIGDIR=`pwd`

if [ $# -lt 1 ]; then
TARGET=$ORIGDIR
else
TARGET=`cd $1; pwd`
fi

ENTRY=NASBuilder
OUTFILE=setup.py
ERRLOG=error.log

IMAGEPATH=$TARGET/images
ICONFILE=$IMAGEPATH/OXE810DSE.icns

cleanup ()
{
	# Cleanup the residues
	for f in "dist build $OUTFILE"; do
		rm -rf $TARGET/$f
	done
}

cleanup

echo
echo "###################################"
echo "# Generating $OUTFILE             #"
echo "###################################"
echo 
py2applet -r $IMAGEPATH --iconfile=$ICONFILE --make-setup $TARGET/$ENTRY.py > /dev/null 2>&1

echo "###################################"
echo "# Generating execution file       #"
echo "###################################"
echo
if [ ! -f $TARGET/$OUTFILE ]; then
	echo "Cannot locate $OUTFILE"
	exit 1
fi

python setup.py py2app > /dev/null 2>$ERRLOG
if [ "$?" == "0" ]; then
	mv $TARGET/dist/$ENTRY.app $TARGET
	echo "Success: output $TARGET/$ENTRY"
	rm -rf $TARGET/$ERRLOG
else
	echo "Error: Please check $TARGET/$ERRLOG"
fi

cleanup

cd $ORIGDIR
exit 0
