@echo off

rem	For those users who want to generate executables for Windows platforms
set /a error=0
set CurrentDir=%CD%

if "%1" == "" (
	set /a error=1
	goto out
)
set PythonPath=%1

if "%2" == "" (
	rem set /a error=1
	rem goto out
	set TargetPath=.\
) else (
	set TargetPath=%2
)
set TargetPath=%2

cd %TargetPath% > NUL
set WorkDir=%CD%

set outfile=setup.py
set Entry=NASBuilder

set Application=NASBuilder
set iconfile=OXE810DSE.ico

rmdir build dist %Application% /s/q 2> NUL
del %outfile% 2> NUL

echo.
echo ###################################
echo # Generating setup.py             #
echo ###################################
echo.

echo # setup.py > %outfile%
echo from distutils.core import setup >> %outfile%
echo import py2exe >> %outfile%
echo import glob >> %outfile%

rem echo setup(windows=["%Entry%.py"], >> %outfile%
echo setup(windows=[{"script":"%Entry%.py", "icon_resources":[(1,"images\OXE810DSE.ico")]}], >> %outfile%
echo 	data_files=[("images", glob.glob("images/*.png")) >> %outfile%
echo 	]) >> %outfile%

echo ###################################
echo # Generating execution file       #
echo ###################################
echo.

if exist %outfile% (
	%PythonPath% %outfile% py2exe > NUL
) else (
	echo Cannot locate %outfile%
	set /a error=1
)

if exist dist (
	ren dist %Application% 2> NUL
) else (
	set /a error=1
)

:out
cd %CurrentDir%
if "%error%" == "1" (
	echo Usage: BuildExe.bat Python_path [Target_path]
	echo Example:
	echo 	BuildExe.bat C:\Python25\python.exe discoverer
) else (
	echo Success: output %WorkDir%\%Application%
)
rmdir build /s/q 2> NUL
del %outfile% 2> NUL
