#!/usr/bin/python

from Config import *

MOUNT_IMAGE_BASE = '/mnt/image'
MOUNT_DISK_BASE = '/mnt/disk'
WORKAREA = '/tmp/NASInstall'

ENV_LIB = ['/lib', '/usr/lib', '/usr/local/lib']
ENV_PATH = ['/bin', '/sbin', '/usr/bin', '/usr/sbin', '/usr/local/bin', '/usr/local/sbin']

SINGLE_DRIVE = ['/dev/sda']
DUAL_DRIVE = ['/dev/sda', '/dev/sdb']

SYS_1NC = '1nc'
SYS_2NC = '2nc'

CMD_CREAT_PART = [
	'dd if=/dev/zero of=%s bs=1M count=32',
	'parted %s mklabel gpt',
	'parted %s mkpart primary 16M 2064M',
	'parted %s set 1 raid on',
	'parted %s mkpart primary 2064M 2576M',
	'parted %s set 2 raid on',
	'parted %s mkpart primary 2576M 4624M',
	'parted %s set 3 raid on',
	'parted %s mkpart primary 4624M 100%%',
	'parted %s set 4 raid on',
	'parted %s print',
	'wait'
]

BOOTROM_TMP_NAME = 'rom_codes'
BOOTROM_OFFSET = 0x1a4
BOOTROM_CODES = [
	0x00, 0xe2, 0x00, 0x00,
	0x00, 0xdf, 0x00, 0x00,
	0x00, 0x03, 0x00, 0x00,
	0x22, 0x03, 0x00, 0x00,
	0x22, 0x00, 0x00, 0x00,
	0x00, 0x03, 0x00, 0x00
]

CMD_WRITE_BM_CODES = 'dd if=%s of=%s bs=512'

CMD_WR_SECT = [
	'dd if=%s/stage1.wrapped of="%s" bs=512 seek=34',
	'dd if=%s/u-boot.wrapped of="%s" bs=512 seek=36',
	'dd if=%s/uImage of="%s" bs=512 seek=290',
	'dd if=%s/uImage.1 of="%s" bs=512 seek=8482',
	'dd if=%s/uUpgradeRootfs of="%s" bs=512 seek=16674',
	'dd if=%s/stage1.wrapped of="%s" bs=512 seek=57088',
	'dd if=%s/u-boot.wrapped of="%s" bs=512 seek=57090',
	'dd if=%s/uImage of="%s" bs=512 seek=57344'
]

CMD_START_RAID = [
	'mdadm --create /dev/md1 --raid-devices=2 --level=raid1 --run --assume-clean %s %s',
	'mdadm --create /dev/md2 --raid-devices=2 --level=raid1 --run --assume-clean %s %s',
	'mdadm --create /dev/md3 --raid-devices=2 --level=raid1 --run --assume-clean %s %s',
]

CMD_START_PART4_RAID_DUAL = 'mdadm --create /dev/md4 --raid-devices=2 --level=raid1 --run --assume-clean %s %s'

CMD_START_PART4_RAID_SINGLE = 'mdadm --create /dev/md4 --raid-devices=2 --level=raid1 --run %s %s'

CMD_SLEEP = 'sleep %s'

CMD_STOP_RAID = [
	'mdadm --stop /dev/md1',
	'mdadm --stop /dev/md2',
	'mdadm --stop /dev/md3',
	'mdadm --stop /dev/md4',
]
CMD_REBOOT='reboot'
CMD_FORMAT_PART = [
	'mkfs.ext3 /dev/md1',
	'mkswap /dev/md2',
	'mkfs.ext3 /dev/md3',
]

CMD_FORMAT_PART4 = 'mkfs.xfs -f /dev/md4'

CMD_MOUNT_PART4 = 'mount -t xfs /dev/md4 %s' % MOUNT_DISK_BASE

CMD_UNTAR_IMAGE = 'tar -jxf %s'

#IMAGE_PATH = MOUNT_DISK_BASE
IMAGE_PREFIX = 'images_%s' % VERSION
ROOTFS_IMAGE = 'rootfs.arm.ext2'
IMAGE_PATH = '%s/%s' % (MOUNT_DISK_BASE, IMAGE_PREFIX)
CMD_UNZIP_ROOTFS = 'bunzip2 %s/%s.bz2' % (IMAGE_PATH, ROOTFS_IMAGE)

CMD_MOUNT_ROOTFS = [
	'losetup /dev/loop1 %s/%s' % (IMAGE_PATH, ROOTFS_IMAGE),
	'mount /dev/loop1 %s' % MOUNT_IMAGE_BASE,
]

##############################################################################
CMD_COPY_ROOTFS = [
	# Create Work Area
	'mkdir -p %s' % WORKAREA,
	'mkdir -p %s/disk' % WORKAREA,
	# mount disks
	'mount /dev/md1 %s/disk' % WORKAREA,
	'mkdir -p %s/disk/var' % WORKAREA,
	'mount /dev/md3 %s/disk/var' % WORKAREA,
	# copy
	'cp -a %s/* %s/disk' % (MOUNT_IMAGE_BASE, WORKAREA),
	# Version
	# Change the System type
	# unmount
]
CMD_SET_VERSION = 'echo %s > ' + WORKAREA + '/disk/var/lib/current-version'
CMD_SET_DUAL = 'touch ' + WORKAREA + '/disk/var/oxsemi/freshinstall'
CMD_SYS_TYPE = 'sed -i -e "s:system_type[ ^t]*=.*\$:system_type=%s:" ' + WORKAREA + '/disk/var/oxsemi/network-settings'
CMD_COPY_ROOTFS_UNMOUNT = [
	'umount %s/disk/var' % WORKAREA,
	'umount %s/disk' % WORKAREA
]
##############################################################################

CMD_FINALIZE = [
	'sync;sync;sync',
	'umount %s' % MOUNT_IMAGE_BASE,
	'losetup -d /dev/loop1',
	'umount %s' % MOUNT_DISK_BASE,
	CMD_FORMAT_PART4
]

CMD_UNMOUNT_ALL = [
	'umount %s' % MOUNT_IMAGE_BASE,
	'umount %s' % MOUNT_DISK_BASE,
	'umount /dev/md1',
	'umount /dev/md3'
]

CMD_CLEAN_WORKAREA = [
	'rm -rf %s' % WORKAREA,
]

CMD_CLEAN_ZOMBIES = [
	# Just in case the user aborts when decompressing
	'killall bunzip2',
	'killall tar'
]

##############################################################################
# Commands for Update
##############################################################################
CMD_SET_UPDATE = 'echo -n "1" | dd of=/dev/sda seek=288 bs=512'

