#!/usr/bin/python

import sys,os,re

##############################################################################
# Global Definition
##############################################################################
MAX_BUFSIZ = 1460	# TCP MSS
DECOMP_ABILITY = 266480	# Bps
##############################################################################

# Error Code
ERR_OK, \
ERR_SYS,    \
ERR_SOCK,	\
ERR_DECODE, \
ERR_ARGV,   \
ERR_INVALID,    \
ERR_EXIST,  \
ERR_CONNECT, \
ERR_EXEC,	\
ERR_TRANS,	\
ERR_FILE,	\
ERR_ABORT,	\
ERR_NONEXIST = range(13)

def CalBcast(ipStr, maskStr):
	ip = ipStr.split('.')
	mask = maskStr.split('.')
	bcastStr = ''
	dot = 0
	for idx, addr in enumerate(ip):
		b = int(addr) | ((~(int(mask[idx]))) & 255)
		if dot:
			bcastStr += '.'
		else:
			dot = 1
		bcastStr += str(b)
	return bcastStr

def isWindows():
	import platform
	if platform.system() in ('Windows', 'Microsoft'):
		return True
	else:
		return False

def isDarwin():
	import platform
	if platform.system() == 'Darwin':
		return True
	else:
		return False

def GetInetAddr():

	if isWindows():
		ipconfig=os.popen('ipconfig/all').read()
		inet_addr = re.findall('IP Address.*?:\s*(.*?)\s',ipconfig)
		if not inet_addr:
			inet_addr = re.findall('IPv4.*?:\s*(.*?)[(\s\n]',ipconfig)
	else:
		ifconfig = os.popen('/sbin/ifconfig').read()
		inet_addr = re.findall('inet\saddr:(.*?)\s', ifconfig)

	return inet_addr

def GetNetMask():

	if isWindows():
		ipconfig=os.popen('ipconfig/all').read()
		submask = re.findall('Subnet Mask.*?:\s*(.*)',ipconfig)
		if not submask:
			submask = re.findall('IPv4.*?:\s*.*\n.*?:\s*(.*)', ipconfig)
	else:
		ifconfig=os.popen('/sbin/ifconfig').read()
		submask = re.findall('Mask:(.*?)\s', ifconfig)
	
	return submask

def GetBcastAddr():
	bcast = []
	if isWindows():
		inet = GetInetAddr()
		mask = GetNetMask()
		for idx, addr in enumerate(inet):
			bcast.append(CalBcast(addr.strip(), (mask[idx]).strip()))
	elif isDarwin():
		ifconfig = os.popen('/sbin/ifconfig').read()
		bcast = re.findall('broadcast (.*?)\s', ifconfig)
	else:
		ifconfig=os.popen('/sbin/ifconfig').read()
		bcast = re.findall('Bcast:(.*?)\s', ifconfig)
	return bcast

import array
def EncodeBinary(offset, pad, codes):
	buffer = []
	for i in range(offset):
		buffer.append(pad)
	buffer = buffer + codes
	return array.array('B', buffer)

if __name__ == "__main__":
	print GetBcastAddr()

