#!/usr/bin/python

import sys, time

import wx

##############################################################################
class NASInfo:

	__Columns = (("#", 40),
				("IPv4 Address", 160),
				("MAC Address", 160),
				("Version", 80))
	__NASData = [
		# Appending the control port at the end of the tuple because it's 
		# necessary but user shouldn't care 
		#('192.168.1.1', '00:01:02:03:04:05', '1.0', 8100),
	]

	def Append(self, data):
		self.__NASData.append(data)

	def RemoveAll(self):
		del self.__NASData[:]

	def GetColumnHeaders(self):
		return self.__Columns

	def GetCount(self):
		return len(self.__NASData)

	def GetItem(self, index):
		return self.__NASData[index]

	def UpdateCache(self, start, end):
		pass

##############################################################################
class DiscoverListCtrl(wx.ListCtrl):

	def __init__(self, parent, data, log):
		wx.ListCtrl.__init__(self, parent, -1,
			style = wx.LC_REPORT|wx.LC_VIRTUAL|wx.LC_HRULES|wx.LC_VRULES|
					wx.LC_SORT_ASCENDING|wx.BORDER_NONE)

		self.data = data
		self.log = log
		self.currItem = -1

		self.SetItemCount(data.GetCount())
		columns = data.GetColumnHeaders()
		for col, (text, width) in enumerate(columns):
			self.InsertColumn(col, text)
			self.SetColumnWidth(col, width)
			#self.SetColumnWidth(i, wx.LIST_AUTOSIZE)

		self.attr1 = wx.ListItemAttr()
		self.attr1.SetBackgroundColour("light blue")

		self.Bind(wx.EVT_LIST_ITEM_SELECTED, self.OnItemSelected)
		self.Bind(wx.EVT_LIST_ITEM_ACTIVATED, self.OnItemActivated)
		self.Bind(wx.EVT_LIST_ITEM_DESELECTED, self.OnItemDeselected)

	def OnItemSelected(self, event):
		self.currItem = event.m_itemIndex
		self.log.WriteText('OnItemSelected: "%s", "%s", "%s", "%s %s %s"\n' %
			(self.currItem,
			self.GetItemText(self.currItem),
			self.getColumnText(self.currItem, 1),
			self.getColumnText(self.currItem, 2),
			self.getColumnText(self.currItem, 3),
			self.data.GetItem(self.currItem)[3]))

	def OnItemActivated(self, event):
		self.currItem = event.m_itemIndex
		self.log.WriteText('OnItemActivated: %s\n' %
			(self.GetItemText(self.currItem)))

	def OnItemDeselected(self, event):
		self.log.WriteText("OnItemDeselected: %s\n" % event.m_itemIndex)
		self.currItem = -1

	def getColumnText(self, index, col):
		item = self.GetItem(index, col)
		return item.GetText()

	# Callbacks
	def DoCacheItems(self, event):
		self.data.UpdateCache(event.GetCacheFrom(), event.GetCacheTo())

	def OnGetItemText(self, item, col):
		if col == 0:
			return str(item+1)
		data = self.data.GetItem(item)
		return data[col-1]

	def OnGetItemAttr(self, item):
		if item % 2 == 1:
			return self.attr1
		else:
			return None

