#!/usr/bin/python

import wx

from Common import *
from Config import *

import Discover

import Progress
import NDRP

import wx.lib.platebtn as platebtn
class InitiateButtons(wx.Panel):
	InstallType = ['Single Drive', 'Dual Drive']
	def __init__(self, parent, log):
		wx.Panel.__init__(self, parent, -1, style=wx.WANTS_CHARS)
	
		self.parent = parent	
		self.log = log

		default = platebtn.PB_STYLE_DEFAULT
		square = platebtn. PB_STYLE_SQUARE
		sqgrad = platebtn.PB_STYLE_SQUARE | platebtn.PB_STYLE_GRADIENT
		gradient = platebtn.PB_STYLE_GRADIENT

		#self.SetBackgroundColour('light green')

		# Discover Button
		icon = wx.Image(name=ICON_SEARCH, type=wx.BITMAP_TYPE_PNG)
		icon = icon.Scale(32,32)
		self.discBtn = platebtn.PlateButton(self, wx.ID_ANY, "Probe",
			icon.ConvertToBitmap(), style=gradient)
		self.discBtn.SetFont(wx.Font(12, wx.SWISS, wx.NORMAL, wx.BOLD))

		self.Bind(wx.EVT_BUTTON, self.OnDiscButton, self.discBtn)

		# Install Type
		self.insType = wx.Choice(self, -1, choices = self.InstallType)
		self.insType.SetSelection(0)
		#self.insType.Enable(False)

		self.Bind(wx.EVT_CHOICE, self.OnSelectType, self.insType)

		# Initiate Button
		icon = wx.Image(name=ICON_INSTALL, type=wx.BITMAP_TYPE_PNG)
		icon = icon.Scale(32,32)
		self.instBtn = platebtn.PlateButton(self, wx.ID_ANY, "Initiate",
			icon.ConvertToBitmap(), style=gradient)
		self.instBtn.SetFont(wx.Font(12, wx.SWISS, wx.NORMAL, wx.BOLD))
		#self.instBtn.Enable(False)

		self.Bind(wx.EVT_BUTTON, self.OnInstButton, self.instBtn)

		sizer = self.__DoLayout()
		self.SetSizer(sizer)
		self.Fit()

	def __DoLayout(self):
		sizer = wx.BoxSizer(wx.VERTICAL)
		sizer.Add(self.discBtn, 0, wx.TOP|wx.BOTTOM|wx.LEFT|wx.RIGHT, 20)
		sizer.Add(self.insType, 0, wx.TOP|wx.LEFT|wx.RIGHT, 20)
		sizer.Add(self.instBtn, 0, wx.BOTTOM|wx.LEFT|wx.RIGHT, 20)
		return sizer

	def OnInstButton(self, event):
		self.log.WriteText('OnInstButton Click!\n')
		listCtrl = self.parent.discList
		# Not Probe Yet
		if listCtrl.data.GetCount() == 0 or listCtrl.currItem == -1:
			return
		# Choose NAS Image
		if self.parent.GetNASImage() == '':
			if not self.parent.ChooseNASImage():
				return

		self.gauge = Progress.GaugeDialog(None, 'Initiating the NAS system')

		info = (self.insType.GetCurrentSelection(),) + listCtrl.data.GetItem(listCtrl.currItem)
		client = NDRP.NdrpClient(self.LogMessage, self.OnNdrpExit,
			self.gauge.SetGauge, NDRP.NDRP_TYPE_INITIATE, info,
			self.parent.GetNASImage())
		client.start()

		result = self.gauge.ShowModal()
		if result == wx.ID_CANCEL:
			client.kill()
		client.join()
		self.gauge.Destroy()

	def OnSelectType(self, event):
		self.log.WriteText('OnSelectType: %s\n' % event.GetString())

	def OnDiscButton(self, event):
		self.log.WriteText('OnDiscButton Click!\n')
		self.parent.ClearNASInfo()
		self.discBtn.Enable(False)
		client = NDRP.NdrpClient(self.LogMessage, self.OnNdrpExit,
			self.parent.AppendNASInfo, NDRP.NDRP_TYPE_PROBE, None, None)
		client.setDaemon(True)
		client.start()

	def OnNdrpExit(self, type, retCode):
		self.log.WriteText('OnNdrpExit Run\n')
		if type == NDRP.NDRP_TYPE_PROBE:
			self.discBtn.Enable(True)
		elif type == NDRP.NDRP_TYPE_INITIATE:
			self.gauge.EndModal(wx.ID_OK)
			if retCode == ERR_OK:
				wx.MessageBox('Done! Please wait, restarting the system now.', 'Message', wx.ID_OK)
			elif retCode == -ERR_ABORT:
				self.log.WriteText('User Abort\n')
			else:
				wx.MessageBox('Error Occurred [Code %d]' % retCode,
					'Caution', wx.ID_OK|wx.ICON_ERROR)
		else:
			raise NDRP.NDRPException, 'Unknown Type'

	def LogMessage(self, message):
		self.log.WriteText(message)

class InitiatePanel(wx.Panel):
	def __init__(self, parent, log, mainFrame):
		wx.Panel.__init__(self, parent, -1, style=wx.WANTS_CHARS)

		self.mainFrame = mainFrame
		self.log = log
		self.data = Discover.NASInfo()
		self.__nasImage = ''

		self.discList = Discover.DiscoverListCtrl(self, self.data, self.log)
		self.discBtns = InitiateButtons(self, self.log)

		sizer = self.__DoLayout()
		self.SetSizer(sizer)
		self.Fit()

	def __DoLayout(self):
		sizer = wx.BoxSizer(wx.HORIZONTAL)
		sizer.Add(self.discList, 1, wx.EXPAND)
		sizer.Add(self.discBtns, 0, wx.EXPAND)
		return sizer
	
	def SetNASImage(self, fname):
		self.__nasImage = fname

	def GetNASImage(self):
		return self.__nasImage

	wildcard = "Image files (*.tar.bz2)|*.tar.bz2|All files (*.*)|*.*"

	def ChooseNASImage(self):
		isSelected = False
		dlg = wx.FileDialog(self, "Choose PLX NAS Image File", os.getcwd(),
			style=wx.OPEN, wildcard=self.wildcard)
		if dlg.ShowModal() == wx.ID_OK:
			fname = dlg.GetPath()
			self.mainFrame.SetTitle(self.mainFrame.title + ' -- ' + fname)
			self.SetNASImage(fname)
			isSelected = True
		dlg.Destroy()
		return isSelected

	def AppendNASInfo(self, ipStr, macStr, verStr, port):
		self.data.Append((ipStr, macStr, verStr, port))
		count = self.data.GetCount()
		self.log.WriteText('AppendNASInfo: current count = %d\n' % count)
		self.discList.SetItemCount(count)
		#self.discList.RefreshItems(0, count)

	def ClearNASInfo(self):
		self.log.WriteText('ClearNASInfo\n')
		self.discList.SetItemCount(0)
		self.data.RemoveAll()

