#!/usr/bin/python

import os
import time

import wx
import wx.aui
import wx.html

##############################################################################
# MainFrame Layout
##############################################################################
class DiscoverFrame(wx.Frame):

	def __init__(self, parent):
		self.title = "Discover Tool V1.0"
		wx.Frame.__init__(self, parent, -1, self.title, size=(640,480))
		self.initStatusBar()
		self.createMenuBar()
		self.createToolBar()

		self.mainPnl = wx.Panel(self)

		self.SetIcon(wx.Icon(name=ICON_APP, type=wx.BITMAP_TYPE_PNG))

		try:
			self.tbicon = DiscoverTaskBarIcon(self)
		except:
			self.tbicon = None

		self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)
		self.Bind(wx.EVT_ICONIZE, self.OnIconify)
		self.Bind(wx.EVT_MAXIMIZE, self.OnMaximize)

		self.Centre(wx.BOTH)

		# Create a Notebook
		self.nb = wx.Notebook(self.mainPnl, -1, style=wx.CLIP_CHILDREN)
		imgList = wx.ImageList(16, 16)
		for png in [ICON_PROBE]:
			img = wx.Image(name=png, type=wx.BITMAP_TYPE_PNG)
			img = img.Scale(16,16)
			imgList.Add(img.ConvertToBitmap())
		self.nb.AssignImageList(imgList)

		# Set up a log window
		self.log = wx.TextCtrl(self.mainPnl, -1,
			style = wx.TE_MULTILINE|wx.TE_READONLY|wx.HSCROLL)
		if wx.Platform == "__WXMAX__":
			self.log.MacCheckSpelling(False)

		wx.Log_SetActiveTarget(DiscoverLogger(self.log))

		self.Bind(wx.EVT_ACTIVATE, self.OnActivate)
		wx.GetApp().Bind(wx.EVT_ACTIVATE_APP, self.OnAppActivate)

		#self.nb.SetSelection(0)
		self.discPnl = Initiator.InitiatePanel(self.nb, self.log, self)
		self.nb.AddPage(self.discPnl, "NAS Builder", imageId=0)

		self.uimgr = self.__DoLayout()
		self.uimgr.Update()

	def __DoLayout(self):
		uimgr = wx.aui.AuiManager()
		uimgr.SetManagedWindow(self.mainPnl)
		uimgr.AddPane(self.nb, wx.aui.AuiPaneInfo().CenterPane()
					.Name("NAS Builder"))
		uimgr.AddPane(self.log, wx.aui.AuiPaneInfo().
					Bottom().BestSize((-1, 200)).
					MinSize((-1, 150)).
					Floatable(False).FloatingSize((500, 160)).
					Caption('Log Messages').
					CloseButton(False).
					Name('LogWindow'))
		return uimgr

	def OnActivate(self, event):
		#wx.LogMessage("OnActivate: %s" % event.GetActive())
		event.Skip()

	def OnAppActivate(self, event):
		#wx.LogMessage("OnAppActivate: %s" % event.GetActive())
		event.Skip()

	def OnIconify(self, event):
		wx.LogMessage("OnIconify: %s" % event.Iconized())
		event.Skip()

	def OnMaximize(self, event):
		wx.LogMessage("OnMaximize: %s" % event.Iconized())
		event.Skip()

	def initStatusBar(self):
		self.statusbar = self.CreateStatusBar()
		self.statusbar.SetFieldsCount(1)

	def menuData(self):
		return (("&File",
					("&Open\tCtrl-O", "Open image file",
						self.OnImageOpen, ICON_OPEN),
					("", "", "", ""),
					("E&Xit\tCtrl-X", "Exit", self.OnCloseWindow, ICON_EXIT)),
				
				("&Help",
					("&About\tCtrl-A", "Show about window",
						self.OnAbout, ICON_ABOUT)))

	def createMenuBar(self):
		menuBar = wx.MenuBar()
		for eachMenuData in self.menuData():
			menuLabel = eachMenuData[0]
			menuItems = eachMenuData[1:]
			menuBar.Append(self.createMenu(menuItems), menuLabel)
		self.SetMenuBar(menuBar)

	def createMenu(self, menuData):
		menu = wx.Menu()
		for eachLabel, eachStatus, eachHandler, eachImage in menuData:
			if not eachLabel:
				menu.AppendSeparator()
				continue
			menuItem = wx.MenuItem(menu, -1, eachLabel, eachStatus)
			if eachImage:
				img = wx.Image(name=eachImage, type=wx.BITMAP_TYPE_PNG)
				img = img.Scale(16,16)
				menuItem.SetBitmap(img.ConvertToBitmap())
			menu.AppendItem(menuItem)
			self.Bind(wx.EVT_MENU, eachHandler, menuItem)
		return menu

	def createMenuItem(self, menu, label, status, handler, kind=wx.ITEM_NORMAL):
		if not label:
			menu.AppendSeparator()
			return
		menuItem = menu.Append(-1, label, status, kind)
		self.Bind(wx.EVT_MENU, handler, menuItem)

	def createToolBar(self):
		toolbar = self.CreateToolBar()
		for each in self.toolbarData():
			self.createSimpleTool(toolbar, *each)
		toolbar.Realize()

	def createSimpleTool(self, toolbar, label, filename, help, handler):
		if not label:
			toolbar.AddSeparator()
			return
		icon = wx.Image(filename, wx.BITMAP_TYPE_PNG)
		icon = icon.Scale(16,16)
		tool = toolbar.AddSimpleTool(-1, icon.ConvertToBitmap(), label, help)
		self.Bind(wx.EVT_MENU, handler, tool)

	def toolbarData(self):
		return (("Open", ICON_OPEN , "Open image file", self.OnImageOpen),
				("", "", "", ""))
	
	def OnCloseWindow(self, event):
		if self.tbicon is not None:
			self.tbicon.Destroy()
		self.Destroy()

	def OnPreference(self, event):
		pass

	def OnImageOpen(self, event):
		self.discPnl.ChooseNASImage()

	def OnAbout(self, event):
		dlg = DiscoverAbout(self)
		dlg.ShowModal()
		dlg.Destroy()

class DiscoverAbout(wx.Dialog):
	text = '''
<html>
<body bgcolor="#ACAA60">
<center><table bgcolor="#455481" width="100%" cellspacing="0"
cellpadding="0" border="1">
<tr>
    <td align="center"><h2>About Discover Tool</h2></td>
</tr>
</table>
</center>
<p><b>Discover Tool v1.0-2010.03.29</b> is a PC utility used for locating
the network drive and creating the initial NAS system.

</p>
</body>
</html>
'''

	def __init__(self, parent):
		wx.Dialog.__init__(self, parent, -1, 'About PLX NAS Builder',
			size=(440, 300))
		html = wx.html.HtmlWindow(self)
		html.SetPage(self.text)
		button = wx.Button(self, wx.ID_OK, "OK")

		sizer = wx.BoxSizer(wx.VERTICAL)
		sizer.Add(html, 1, wx.EXPAND|wx.ALL, 5)
		sizer.Add(button, 0, wx.ALIGN_CENTER|wx.ALL, 5)

		self.SetSizer(sizer)
		self.Layout()

class DiscoverTaskBarIcon(wx.TaskBarIcon):
	TBMENU_RESTORE = wx.NewId()
	TBMENU_CLOSE = wx.NewId()

	def __init__(self, frame):
		wx.TaskBarIcon.__init__(self)
		self.frame = frame
		# Set the image
		icon = self.MakeIcon(wx.Image(name=ICON_APP, type=wx.BITMAP_TYPE_PNG))
		self.SetIcon(icon, 'PLX NAS Builder Icon')
		self.Bind(wx.EVT_TASKBAR_LEFT_DCLICK, self.OnTaskBarActivate)
		self.Bind(wx.EVT_MENU, self.OnTaskBarActivate, id=self.TBMENU_RESTORE)
		self.Bind(wx.EVT_MENU, self.OnTaskBarClose, id=self.TBMENU_CLOSE)

	def MakeIcon(self, img):
		if "wxMSW" in wx.PlatformInfo:
			img = img.Scale(16,16)
		elif "wxGTK" in wx.PlatformInfo:
			img = img.Scale(22,22)
		icon = wx.IconFromBitmap(img.ConvertToBitmap())
		return icon

	def CreatePopupMenu(self):
		menu = wx.Menu()
		menu.Append(self.TBMENU_RESTORE, "Restore NAS Builder")
		menu.Append(self.TBMENU_CLOSE, "Close NAS Builder")
		return menu

	def OnTaskBarActivate(self, event):
		if self.frame.IsIconized():
			self.frame.Iconize(False)
		if not self.frame.IsShown():
			self.frame.Show(True)
		self.frame.Raise()

	def OnTaskBarClose(self, event):
		wx.CallAfter(self.frame.Close)

##############################################################################
# Logger
##############################################################################

class DiscoverLogger(wx.PyLog):
	""" Provide a Logger Interface """
	def __init__(self, textCtrl):
		wx.PyLog.__init__(self)
		self.tc = textCtrl

	def DoLogString(self, message, timeStamp):
		message = time.strftime("%X", time.localtime(timeStamp)) + \
			': ' + message
		if self.tc:
			self.tc.AppendText(message + '\n')

##############################################################################
# Application
##############################################################################
class DiscoverApp(wx.App):

	def OnInit(self):
		#bmp = wx.Image(IMG_SPLASH).ConvertToBitmap()
		#wx.SplashScreen(bmp, wx.SPLASH_CENTRE_ON_SCREEN | wx.SPLASH_TIMEOUT,
			#1000, None, -1)
		wx.Yield()

		wx.SystemOptions.SetOptionInt("mac.window-plain-transition", 1)
		self.SetAppName(APPLICATION)

		frame = DiscoverFrame(None)
		frame.Show(True)
		self.SetTopWindow(frame)
		return True

if __name__ == '__main__':
	try:
		path = os.path.abspath(__file__)
		path = os.path.dirname(path)
		os.chdir(path)
	except:
		pass
	from Config import *
	import Initiator
	app = DiscoverApp(False)
	app.MainLoop()

