#!/usr/bin/python

from Common import *
import wx

class GaugeDialog(wx.Dialog):
	def __init__(self, parent, caption):
		if isWindows():
			wx.Dialog.__init__(self, parent, -1, caption, size = (300, 180))
		else:
			wx.Dialog.__init__(self, parent, -1, caption, size = (300, 150))

		self.progress = ProgressPanel(self)
		cancelBtn = wx.Button(self, wx.ID_CANCEL, "Cancel")

		sizer = wx.BoxSizer(wx.VERTICAL)
		sizer.Add(self.progress, 1, wx.EXPAND)
		sizer.Add(cancelBtn, 0, wx.ALIGN_CENTER|wx.ALL, 5)

		self.SetSizer(sizer)
		self.Layout()

	def SetMainProgress(self, count):
		self.progress.mainGauge.SetValue(count)

	def SetMainCaption(self, caption):
		self.progress.mainCaption.SetLabel(caption)

	def SetSubProgress(self, count):
		self.progress.subGauge.SetValue(count)

	def SetSubCaption(self, caption):
		self.progress.subCaption.SetLabel(caption)

	def SetSubGauge(self, value):
		self.SetSubProgress(value[0])
		self.SetSubCaption(value[1])

	def SetMainGauge(self, value):
		self.SetMainProgress(value[0])
		self.SetMainCaption(value[1])

	def SetGauge(self, value1, value2):
		if value1 is not None:
			self.SetMainGauge(value1)
		if value2 is not None:
			self.SetSubGauge(value2)

class ProgressPanel(wx.Panel):
	def __init__(self, parent):
		wx.Panel.__init__(self, parent, -1)

		self.mainCaption = wx.StaticText(self, -1, '', (45, 10))
		self.mainGauge = wx.Gauge(self, -1, 100, (45, 25), (200, 25))

		self.subCaption = wx.StaticText(self, -1, '', (45, 60))
		self.subGauge = wx.Gauge(self, -1, 100, (45, 75), (200, 25))

if __name__ == '__main__':
	class App(wx.App):

		def __init__(self, redirect=False, filename=None):
			wx.App.__init__(self, redirect, filename)

		def TimerHandler(self, event):
			self.count = self.count + 1
			if self.count >= 100:
				self.count = 0
				self.dlg.EndModal(wx.ID_OK)
			self.dlg.SetMainCaption('Current' + str(self.count))
			self.dlg.SetMainProgress(self.count)

		def OnInit(self):
			self.Bind(wx.EVT_TIMER, self.TimerHandler)
			self.timer = wx.Timer(self)

			self.count = 0

			self.dlg = GaugeDialog(None, 'Test Gauge')
			self.timer.Start(100)
			result = self.dlg.ShowModal()
			self.dlg.Destroy()
			return True

	app = App(False)
	app.MainLoop()

